/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.base.VWDebug;
import filenet.vw.sysutils.VWPropertyReader;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class VWTaskProperties
extends Properties {
    public static final String PROPERTIES_FILE = "TaskManager.Properties";
    public static final String DEV_MODE = "TaskManager.DevMode";
    public static final String LOCALE = "TaskManager.Locale";
    public static final String HOST = "TaskManager.Host";
    public static final String CONSOLIDATED_VIEW = "TaskManager.ConsolidatedView";
    public static final String SERVICE_MODE = "TaskManager.ServiceMode";
    public static final String SERVICE_NAME = "TaskManager.ServiceName";
    public static final String SERVICE_DISPLAYNAME = "TaskManager.ServiceDisplayName";
    public static final String P8TASKMAN_HOME = "TaskManager.P8TASKMAN_HOME";
    public static final String TASKMANAGER_CLASSPATH = "TaskManager.Classpath";
    public static final String DEBUG = "TaskManager.Debug";
    public static final String PRODUCT_ID = "TaskManager.ProductID";
    public static final String VMFLAGS = "TaskManager.VMFlags";
    public static final String HA_SHARED_DIRECTORY = "TaskManager.HASharedDirectory";
    public static final String ROUTER_ADMIN = "TaskManager.Router";
    public static final String ROUTER_CSADMINISTER = "TaskManager.Router.CustomService.Administer";
    public static final String PPM = "TaskManager.PPM";
    public static final String PROCESS_OPTIMZER = "TaskManager.ProcessSimulator";
    public static final String PROCESS_OPTIMIZER_INSTALL = "TaskManager.ProcessSimulator.Install";
    public static final String PROCESS_OPTIMZER_CP = "TaskManager.ProcessSimulator.ClassPath";
    public static final String PROCESS_OPTIMIZER_PROPS = "TaskManager.ProcessSimulator.Props";
    public static final String PROCESS_OPTIMIZER_DTD = "TaskManager.ProcessSimulator.DTD";
    public static final String PROCESS_OPTIMIZER_VMFLAGS = "TaskManager.ProcessSimulator.VMFlags";
    public static final String COMPONENT_MANAGER = "TaskManager.ComponentManager";
    public static final String COMPONENT_MANAGER_CP = "TaskManager.ComponentManager.ClassPath";
    public static final String COMPONENT_MANAGER_DISABLEJMS = "TaskManager.ComponentManager.DisableJMS";
    public static final String COMPONENT_MANAGER_DISABLEWS = "TaskManager.ComponentManager.DisableWebServices";
    public static final String COMPONENT_MANAGER_LOGINCONFIGFILE = "TaskManager.ComponentManager.LoginConfigFile";
    public static final String COMPONENT_MANAGER_CSADMINISTER = "TaskManager.ComponentManager.CustomService.Administer";
    public static final String COMPONENT_MANAGER_CEAPI_CLASSPATH = "TaskManager.ComponentManager.CEAPI.ClassPath";
    public static final String COMPONENT_MANAGER_CEAPI_JVMOPTS = "TaskManager.ComponentManager.CEAPI.JVMOpts";
    public static final String WFSERVICES = "TaskManager.ProcessService";
    public static final String WFSERVICES_MINIINSTALL = "TaskManager.ProcessService.MiniInstall";
    public static final String WFSERVICES_FNSW = "TaskManager.ProcessService.Fnsw";
    public static final String WFSERVICES_FNSWLOC = "TaskManager.ProcessService.FnswLoc";
    public static final String WFSERVICES_DATABASE_TYPE = "TaskManager.ProcessService.DatabaseType";
    public static final String WFSERVICES_PEIOR_HOST = "TaskManager.ProcessService.PEIORHost";
    public static final String WFSERVICES_PEIOR_PORT = "TaskManager.ProcessService.PEIORPort";
    public static final String WFSERVICES_DEVELOPMENT_ENV = "TaskManager.ProcessService.DevelopmentEnv";
    public static final String WFSERVICES_CLUSTER = "TaskManager.ProcessService.Cluster";
    public static final String WFSERVICES_ADVANCED_RDB_EDITING = "TaskManager.ProcessService.AdvancedRDBEditing";
    public static final String RULES_ENGINE = "TaskManager.RulesEngine";
    public static final String RULES_ENGINE_CP = "TaskManager.RulesEngine.ClassPath";
    public static final String RULES_ENGINE_PROPS = "TaskManager.RulesEngine.Props";
    public static final String RULES_ENGINE_ARGS = "TaskManager.RulesEngine.Args";
    public static final String RULES_ENGINE_VMARGS = "TaskManager.RulesEngine.VMArgs";
    public static final String PROCESS_ANALYZER = "TaskManager.CaseAnalyzer";
    public static final String PROCESS_ANALYZER_INSTALL = "TaskManager.CaseAnalyzer.Install";
    public static final String PROCESS_ANALYZER_CP = "TaskManager.CaseAnalyzer.ClassPath";
    public static final String PROCESS_ANALYZER_VMFLAGS = "TaskManager.CaseAnalyzer.VMFlags";
    public static final String BROKER = "TaskManager.Broker";
    public static final String IORSERVER = "TaskManager.IORServer";
    public static final String SERIVCE_MANAGER_PROCESS = "TaskManager.ServiceManagerProcess";
    public static final String AUTO_START = "TaskManager.AutoStart";
    public static final String AUTO_STOP = "TaskManager.AutoStop";

    protected boolean getBoolean(String key) {
        if (key == null) {
            return false;
        }
        String value = this.getProperty(key);
        return value != null && value.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static VWTaskProperties getInstance(String propertiesPath) {
        String method = "getInstance";
        VWTaskProperties p = new VWTaskProperties();
        FileInputStream istream = null;
        try {
            File file = new File(propertiesPath).getAbsoluteFile();
            if (file.exists()) {
                Properties prop = VWPropertyReader.load(file);
                Set<Object> s = prop.keySet();
                for (String string : s) {
                    String value = prop.getProperty(string);
                    p.put(string, value);
                }
            } else {
                VWDebug.logInfo("Properties file does not exist at: " + file.getPath());
            }
        }
        catch (Exception e) {
            VWDebug.logException(e, "Exception loading property file: " + propertiesPath);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                    istream = null;
                }
                catch (Exception e) {}
            }
        }
        return p;
    }

    protected static void initSystemProperties(VWTaskProperties p) {
        if (p == null) {
            return;
        }
        for (String string : p.keySet()) {
            if (string.toUpperCase(Locale.ENGLISH).startsWith("TASKMANAGER.")) continue;
            System.setProperty(string, p.getProperty(string));
        }
    }

    protected static void logProperties(String title, Properties props) {
        VWDebug.logInfo("");
        VWDebug.logInfo("*******************************************************");
        VWDebug.logInfo(title + " PROPERTIES");
        VWDebug.logInfo("*******************************************************");
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            VWDebug.logInfo(propName + "=" + props.getProperty(propName));
        }
        VWDebug.logInfo("*******************************************************");
        VWDebug.logInfo("");
    }

    private VWTaskProperties() {
    }

    public static String _get_FILE_DATE() {
        return "$Date:   05 May 2009 11:12:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.42  $";
    }
}

